package easik.ui.menu;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.states.AddPullbackConstraintState;


/**
 * Add a simple pullback constraint menu option and action.
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @author Vera Ranieri 2006
 * @version 2006-05-25 Vera Ranieri
 */
public class AddPullbackConstraintAction extends AbstractAction {
	/**
	 * Creates and initializes the menu option.
	 *
	 */
	public AddPullbackConstraintAction() {
		super();
		putValue(AbstractAction.NAME, "Add a Pullback Constraint");
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Create a pullback constraint from a set of paths");
	}

	/**
	 * Creates the pullback if the selection is appropriate.
	 *
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
		if(!Easik.getInstance().getFrame().getSketch().getEntities().isEmpty()){
			Easik.getInstance().getStateManager().pushState(
				new AddPullbackConstraintState(Easik.getInstance().getFrame().getSketch()));
		}
		else{
			JOptionPane.showMessageDialog(null, "Sketch cannot be empty.", "Error", JOptionPane.ERROR_MESSAGE);
		}
		
	}
}
